#ifndef _ENTRY_H
#define _ENTRY_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define CRYPTFLAGS ROUNDRESULT | NONREPETITION | ENSUREOFFSET
#define MAX_STATUS_TEXT 10240

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <SQL.H>

#include "../../SharedSource/Debug.H"

#include "../../SharedClasses/NASCCL/NASCCL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/SQLClass/cSQL.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern HINSTANCE ghAppInstance;

extern char gsAppCopyRight[64];
extern char gsFileVersion[32];
extern char gsTitleCaption[64];
extern char gsRegistryKey[255];

extern bool gbIsMainDialogOpen;
extern bool gbIsMonitorDialogOpen;
extern bool gbKillApplication;
extern bool gbApplicationRunning;
extern bool gbDebugMode;
extern bool gbConsoleOpen;
extern bool gbDropBadPackets;
extern bool gbPacketMode;
extern bool gbUseCompression;
extern bool gbDeleteCompressedFiles;

extern int giNextClientID;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StartRoutine(char *sCmdLine);
bool xMainEntry(void);
bool WaitOnApplicationToExit(void);
bool StartServer(void);
bool StopServer(void);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _MainDialogInfo{
	HWND LogList_hWnd;
	HWND StatusBar_hWnd;
	HMENU Menu_hWnd;
}; extern _MainDialogInfo MDI;

struct _ConnectedClientInfo{
	int iThisClient;
	int iAuthStep;

	char sCompanyName[64];
	char sFileName[MAX_PATH];
	char sPassword[64];
	char sClientVersion[16];
	char sCompanyDatabase[100];

	bool bIsAuthenticated;
	bool bIsEncryptionInit;
	bool bWPIndexConnected;
	bool bWPCustomerConnected;
	bool bRequestInit;

	NASCCL cNASCCL;

	CSQL cIndexSQL;
	CSQL cCustSQL;

}; extern _ConnectedClientInfo *CCI;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

